/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.bmp;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.bmp.BMPImageWriter;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class BMPImageWriterSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.bmp.BMPImageReaderSpi"};
    private static String[] formatNames = new String[]{"bmp", "BMP"};
    private static String[] extensions = new String[]{"bmp"};
    private static String[] mimeTypes = new String[]{"image/bmp, image/x-bmp, image/x-windows-bmp"};
    private boolean registered = false;

    public BMPImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "com.sun.media.imageioimpl.plugins.bmp.BMPImageWriter", ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_bmp_image_1.0", "com.sun.media.imageioimpl.plugins.bmp.BMPMetadataFormat", null, null);
    }

    public String getDescription(Locale locale) {
        return "Standard BMP Image Writer";
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        Object coreWriterSPI;
        if (this.registered) {
            return;
        }
        this.registered = true;
        Class<?> coreWriterSPIClass = null;
        try {
            coreWriterSPIClass = Class.forName("com.sun.imageio.plugins.bmp.BMPImageWriterSpi");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (coreWriterSPIClass != null && (coreWriterSPI = registry.getServiceProviderByClass(coreWriterSPIClass)) != null) {
            registry.setOrdering(category, this, coreWriterSPI);
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        int dataType = type.getSampleModel().getDataType();
        if (dataType < 0 || dataType > 3) {
            return false;
        }
        SampleModel sm = type.getSampleModel();
        int numBands = sm.getNumBands();
        if (numBands != 1 && numBands != 3) {
            return false;
        }
        if (numBands == 1 && dataType != 0) {
            return false;
        }
        return dataType <= 0 || sm instanceof SinglePixelPackedSampleModel;
    }

    public ImageWriter createWriterInstance(Object extension) throws IIOException {
        return new BMPImageWriter(this);
    }
}

